#!/bin/sh
# postinst script for ancestromania-data
#
# see: dh_installdeb(1)

set -e

# summary of how this script can be called:
#        * <postinst> `configure' <most-recently-configured-version>
#        * <old-postinst> `abort-upgrade' <new version>
#        * <conflictor's-postinst> `abort-remove' `in-favour' <package>
#          <new-version>
#        * <postinst> `abort-remove'
#        * <deconfigured's-postinst> `abort-deconfigure' `in-favour'
#          <failed-install-package> <version> `removing'
#          <conflicting-package> <version>
# for details, see http://www.debian.org/doc/debian-policy/ or
# the debian-policy package


directory=`dirname $0`
echo "Working in $directory"
cd $directory 

export FIREBIRD="$directory"
export LD_LIBRARY_PATH="$directory"

echo "adding firebird group"
if [ -z `egrep -i "^firebird" /etc/group` ]; then
    groupadd firebird
fi

echo "adding firebird user"
if [ -z `egrep -i "^firebird" /etc/passwd` ]; then
    useradd -g firebird firebird
fi

echo "Setting firebird members"
## get UID limit ##
l=$(grep "^UID_MIN" /etc/login.defs)

## use awk to print if UID >= $UID_LIMIT ##
for USER in `awk -F':' -v "limit=${l##UID_MIN}" '{ if ( $3 >= limit ) print $1}' /etc/passwd`;do
	echo "setting $USER as firebird member"
	usermod -a -G firebird $USER
done

# dh_installdeb will replace this with shell code automatically
# generated by other debhelper scripts.

#DEBHELPER#

exit 0
